/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.config.MutantShulkerTrapCommonConfig;
import com.alexander.mutantmore.entities.CustomShulkerBullet;
import com.alexander.mutantmore.entities.MutantShulker;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.util.MiscUtils;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantShulkerTrap
extends Mob
implements IAnimatable,
IAnimationTickable {
    private final TargetingConditions mutantShulkerTargeting = TargetingConditions.m_148353_().m_26883_(64.0).m_148355_().m_26893_();
    private static final EntityDataAccessor<Boolean> SPAWNED_BY_MUTANT_SHULKER = SynchedEntityData.m_135353_(MutantShulkerTrap.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int activateAnimationTick;
    public int activateAnimationLength = 20;
    public int activateActionPoint = 16;
    public int vanishAnimationTick;
    public int vanishAnimationLength = 30;
    public int lifeTime;
    public int snapCooldownTick;
    public int snapCooldownLength = 40;
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(MutantShulkerTrap.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final Predicate<Entity> SNAPPABLE = target -> this.canSnap((Entity)target) && target instanceof LivingEntity && target.m_6084_() && !target.m_20147_() && !target.m_5833_() && (!(target instanceof Player) || !((Player)target).m_7500_());
    private final Predicate<Entity> HURTABLE = target -> this.canHarm((Entity)target) && target instanceof LivingEntity && target.m_6084_() && !target.m_20147_() && !target.m_5833_() && (!(target instanceof Player) || !((Player)target).m_7500_());

    public MutantShulkerTrap(EntityType<? extends MutantShulkerTrap> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.f_21364_ = 1;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setConfigurableAttributeValues() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)MutantShulkerTrapCommonConfig.max_health.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)MutantShulkerTrapCommonConfig.armour.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)MutantShulkerTrapCommonConfig.armour_toughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)MutantShulkerTrapCommonConfig.knockback_resistance.get()).doubleValue());
        this.m_21153_(this.m_21233_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        this.setConfigurableAttributeValues();
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    protected SoundEvent m_7515_() {
        return this.isSpawnedByMutantShulker() ? (SoundEvent)SoundEventInit.MUTANT_SHULKER_TRAP_IDLE.get() : null;
    }

    public int m_8100_() {
        return 200;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundEventInit.MUTANT_SHULKER_TRAP_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventInit.MUTANT_SHULKER_TRAP_DEATH.get();
    }

    protected float m_6121_() {
        return 0.5f;
    }

    boolean canSnap(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TRAP_WONT_SNAP, (Entity)this, target, (Entity)this, null);
    }

    boolean canHarm(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TRAP_CANT_HURT, (Entity)this, target, (Entity)this, null);
    }

    public void m_6710_(LivingEntity p_21544_) {
        if (!this.isSpawnedByMutantShulker() || p_21544_ != null) {
            super.m_6710_(p_21544_);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_5997_(double p_20286_, double p_20287_, double p_20288_) {
    }

    public void m_7334_(Entity p_21294_) {
    }

    protected void m_6138_() {
    }

    public void m_6075_() {
        List snappables;
        super.m_6075_();
        this.tickDownAnimTimers();
        if (!this.m_20096_() && this.isSpawnedByMutantShulker() && !this.f_19853_.f_46443_) {
            ShakeCameraEvent.shake(this.f_19853_, 10, 0.005f, this.m_20183_(), 3, CameraShakePriority.EFFECT);
        }
        if (!(snappables = this.f_19853_.m_6249_((Entity)this, this.m_20191_(), this.SNAPPABLE)).isEmpty() && !this.f_19853_.f_46443_ && this.f_19797_ >= 20 && this.activateAnimationTick <= 0 && this.snapCooldownTick <= 0) {
            this.snapCooldownTick = this.snapCooldownLength;
            this.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_TRAP_TRAP.get());
            this.activateAnimationTick = this.activateAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
        List hurtables = this.f_19853_.m_6249_((Entity)this, this.m_20191_(), this.HURTABLE);
        for (Entity entity : hurtables) {
            if (this.activateAnimationTick != this.activateActionPoint) continue;
            ShakeCameraEvent.shake(this.f_19853_, 20, 0.075f, this.m_20183_(), 5, CameraShakePriority.WEAK_MOB_ACTION);
            if (this.isSpawnedByMutantShulker()) {
                entity.m_6469_(DamageSourceInit.mutantShulkerTrapAttack((LivingEntity)this), ((Double)MutantShulkerTrapCommonConfig.mutant_shulker_damage.get()).floatValue());
            } else {
                entity.m_6469_(DamageSourceInit.mutantShulkerTrapAttack((LivingEntity)this), ((Double)MutantShulkerTrapCommonConfig.player_damage.get()).floatValue());
            }
            if (!(entity instanceof LivingEntity)) continue;
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, ((Integer)MutantShulkerTrapCommonConfig.slowness_length.get()).intValue(), ((Integer)MutantShulkerTrapCommonConfig.slowness_level.get()).intValue()));
        }
        if (this.isSpawnedByMutantShulker()) {
            ++this.lifeTime;
        }
        if (this.snapCooldownTick > 0) {
            --this.snapCooldownTick;
        }
        if (!this.f_19853_.f_46443_ && ((Boolean)MutantShulkerTrapCommonConfig.turns_to_bullet.get()).booleanValue() && this.lifeTime == (Integer)MutantShulkerTrapCommonConfig.turn_to_bullet_time.get()) {
            this.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_TRAP_VANISH.get());
            this.vanishAnimationTick = this.vanishAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)11);
        }
        if (!this.f_19853_.f_46443_ && this.vanishAnimationTick == 1) {
            this.m_146870_();
            if (this.m_5448_() != null) {
                LivingEntity nearestMutantShulker = this.f_19853_.m_45963_(MutantShulker.class, this.mutantShulkerTargeting, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(64.0));
                CustomShulkerBullet bullet = new CustomShulkerBullet(this.f_19853_, (LivingEntity)MoreObjects.firstNonNull((Object)nearestMutantShulker, (Object)((Object)this)), (Entity)this.m_5448_(), Direction.Axis.Y);
                bullet.damage = ((Double)MutantShulkerTrapCommonConfig.shulker_bullet_damage.get()).floatValue();
                bullet.levitationLength = (Integer)MutantShulkerTrapCommonConfig.shulker_bullet_levitation_length.get();
                bullet.levitationLevel = (Integer)MutantShulkerTrapCommonConfig.shulker_bullet_levitation_level.get();
                bullet.m_6027_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                this.f_19853_.m_7967_((Entity)bullet);
            }
        }
        if (!this.f_19853_.f_46443_ && this.activateAnimationTick == 1 && (this.isSpawnedByMutantShulker() && !((Boolean)MutantShulkerTrapCommonConfig.mutant_shulker_multiuse.get()).booleanValue() || !this.isSpawnedByMutantShulker() && !((Boolean)MutantShulkerTrapCommonConfig.player_multiuse.get()).booleanValue())) {
            this.m_146870_();
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.f_19853_.f_46443_ && this.isOwnedBy((LivingEntity)player) && !this.isSpawnedByMutantShulker() && player.m_21120_(hand).m_41619_() && player.m_6047_()) {
            this.m_19998_((ItemLike)ItemInit.MUTANT_SHULKER_TRAP.get());
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource p_32820_, float p_32821_) {
        if (!this.m_20096_() || this.activateAnimationTick > 0 || this.vanishAnimationTick > 0) {
            return false;
        }
        if (!p_32820_.m_19387_() && p_32820_.m_7640_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_32820_.m_7640_();
            if (!p_32820_.m_19372_()) {
                livingentity.m_6469_(DamageSource.m_19335_((Entity)this), ((Double)MutantShulkerTrapCommonConfig.thorns_damage.get()).floatValue());
            }
        }
        return super.m_6469_(p_32820_, p_32821_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWNED_BY_MUTANT_SHULKER, (Object)false);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag p_29495_) {
        super.m_7380_(p_29495_);
        if (this.getOwnerUUID() != null) {
            p_29495_.m_128362_("Owner", this.getOwnerUUID());
        }
        p_29495_.m_128379_("SpawnedByMutantShulker", this.isSpawnedByMutantShulker());
    }

    public void m_7378_(CompoundTag p_29478_) {
        UUID uuid;
        super.m_7378_(p_29478_);
        if (p_29478_.m_128403_("Owner")) {
            uuid = p_29478_.m_128342_("Owner");
        } else {
            String s = p_29478_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setSpawnedByMutantShulker(p_29478_.m_128471_("SpawnedByMutantShulker"));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(p_21817_));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwnedBy(LivingEntity p_21831_) {
        return p_21831_ == this.getOwner();
    }

    public boolean isSpawnedByMutantShulker() {
        return (Boolean)this.m_20088_().m_135370_(SPAWNED_BY_MUTANT_SHULKER);
    }

    public void setSpawnedByMutantShulker(boolean spawnedByMutantShulker) {
        this.m_20088_().m_135381_(SPAWNED_BY_MUTANT_SHULKER, (Object)spawnedByMutantShulker);
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return false;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public void m_7822_(byte p_36869_) {
        if (p_36869_ == 4) {
            this.activateAnimationTick = this.activateAnimationLength;
        } else if (p_36869_ == 11) {
            this.vanishAnimationTick = this.vanishAnimationLength;
        } else {
            super.m_7822_(p_36869_);
        }
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.activateAnimationTick > 0) {
            if (this.isSpawnedByMutantShulker() && ((Boolean)MutantShulkerTrapCommonConfig.mutant_shulker_multiuse.get()).booleanValue() || !this.isSpawnedByMutantShulker() && ((Boolean)MutantShulkerTrapCommonConfig.player_multiuse.get()).booleanValue()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("player_placed_mutant_shulker_trap_activate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_trap_activate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.vanishAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_trap_vanish", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!this.m_20096_() && this.isSpawnedByMutantShulker()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_trap_airborne", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_trap_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void tickDownAnimTimers() {
        if (this.activateAnimationTick > 0) {
            --this.activateAnimationTick;
        }
        if (this.vanishAnimationTick > 0) {
            --this.vanishAnimationTick;
        }
    }

    public void m_6043_() {
        if (!this.isSpawnedByMutantShulker()) {
            this.f_20891_ = 0;
        } else {
            super.m_6043_();
        }
    }
}

